/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.portable_energy_interface;

import com.mrh0.createaddition.config.Config;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class PortableEnergyManager {
    private static final Map<UUID, EnergyStorageHolder> CONTRAPTIONS = new ConcurrentHashMap<UUID, EnergyStorageHolder>();
    private static int tick = 0;

    public static void tick() {
        CONTRAPTIONS.keySet().iterator().forEachRemaining(contraption -> {
            if (System.currentTimeMillis() - PortableEnergyManager.CONTRAPTIONS.get((Object)contraption).heartbeat > 5000L) {
                CONTRAPTIONS.remove(contraption);
            }
        });
    }

    public static void track(MovementContext context) {
        Contraption contraption = context.contraption;
        EnergyStorageHolder holder = CONTRAPTIONS.get(contraption.entity.m_142081_());
        if (holder == null) {
            holder = new EnergyStorageHolder();
            CONTRAPTIONS.put(contraption.entity.m_142081_(), holder);
        }
        holder.addEnergySource(context.tileData, context.localPos);
    }

    public static void untrack(MovementContext context) {
        EnergyStorageHolder holder = CONTRAPTIONS.remove(context.contraption.entity.m_142081_());
        if (holder == null) {
            return;
        }
        holder.removed = true;
    }

    @Nullable
    public static IEnergyStorage get(Contraption contraption) {
        if (contraption.entity == null) {
            return null;
        }
        return CONTRAPTIONS.get(contraption.entity.m_142081_());
    }

    public static class EnergyStorageHolder
    implements IEnergyStorage {
        private int energy = 0;
        private int capacity = 0;
        private long heartbeat;
        private boolean removed = false;
        private final int maxReceive = (Integer)Config.ACCUMULATOR_MAX_INPUT.get();
        private final int maxExtract = (Integer)Config.ACCUMULATOR_MAX_OUTPUT.get();
        private final Map<BlockPos, EnergyData> energyHolders = new HashMap<BlockPos, EnergyData>();

        public EnergyStorageHolder() {
            this.heartbeat = System.currentTimeMillis();
        }

        protected void addEnergySource(CompoundTag nbt, BlockPos pos) {
            this.heartbeat = System.currentTimeMillis();
            if (!nbt.m_128441_("EnergyContent")) {
                return;
            }
            if (this.energyHolders.containsKey(pos)) {
                return;
            }
            EnergyData data = new EnergyData(nbt);
            this.energy += data.energy;
            this.capacity += data.capacity;
            this.energyHolders.put(pos, data);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
            if (!simulate) {
                this.energy += energyReceived;
                int energyLeft = energyReceived;
                for (EnergyData data : this.energyHolders.values()) {
                    if ((energyLeft -= data.receiveEnergy(energyLeft)) <= 0) break;
                }
                if (energyLeft > 0) {
                    throw new IllegalStateException("Failed to store energy.");
                }
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
            if (!simulate) {
                this.energy -= energyExtracted;
                int energyLeft = energyExtracted;
                for (EnergyData data : this.energyHolders.values()) {
                    if ((energyLeft -= data.extractEnergy(energyLeft)) <= 0) break;
                }
                if (energyLeft > 0) {
                    throw new IllegalStateException("Failed to store energy.");
                }
            }
            return energyExtracted;
        }

        public int getEnergyStored() {
            return this.energy;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return !this.removed;
        }

        public boolean canReceive() {
            return !this.removed;
        }
    }

    public static class EnergyData {
        private final CompoundTag nbt;
        private final int capacity;
        private int energy;

        public EnergyData(CompoundTag nbt) {
            CompoundTag energyContent = (CompoundTag)nbt.m_128423_("EnergyContent");
            if (energyContent == null) {
                throw new IllegalArgumentException("EnergyContent is null");
            }
            this.nbt = nbt;
            this.capacity = nbt.m_128451_("EnergyCapacity");
            this.energy = energyContent.m_128451_("energy");
        }

        public int receiveEnergy(int energy) {
            int energyReceived = Math.min(this.capacity - this.energy, energy);
            if (energyReceived == 0) {
                return 0;
            }
            this.energy += energyReceived;
            CompoundTag energyContent = (CompoundTag)this.nbt.m_128423_("EnergyContent");
            energyContent.m_128405_("energy", this.energy);
            return energyReceived;
        }

        public int extractEnergy(int energy) {
            int energyRemoved = Math.min(this.energy, energy);
            if (energyRemoved == 0) {
                return 0;
            }
            this.energy -= energyRemoved;
            CompoundTag energyContent = (CompoundTag)this.nbt.m_128423_("EnergyContent");
            energyContent.m_128405_("energy", this.energy);
            return energyRemoved;
        }
    }
}

